<?php

namespace Config;

use GuzzleHttp\Client;
use ObjectivePHP\Matcher\Matcher;
use ObjectivePHP\ServicesFactory\Config\Service;
use Project\Hydrators\BlogCommentHydrator;
use Project\Hydrators\BlogPostHydrator;
use Project\Hydrators\CatalogServiceHydrator;
use Project\Hydrators\CommentHydrator;
use Project\Hydrators\JobHydrator;
use Project\Hydrators\LegalNoticeHydrator;
use Project\Hydrators\MediaHydrator;
use Project\Hydrators\OffersHydrator;
use Project\Hydrators\PostHydrator;
use Project\Hydrators\ReferencesHydrator;
use Project\Hydrators\ServicesHydrator;
use Project\Hydrators\SideBarHydrator;
use Project\Hydrators\TimelineHydrator;
use Project\Hydrators\WizardSolutionHydrator;
use Project\Managers\BlogCommentManager;
use Project\Managers\BlogPostManager;
use Project\Managers\CacheManager;
use Project\Managers\CatalogServiceManager;
use Project\Hydrators\WizardEntityHydrator;
use Project\Managers\JobManager;
use Project\Managers\LegalNoticeManager;
use Project\Managers\MediaManager;
use Project\Managers\ServicesManager;
use Project\Managers\SideBarManager;
use Project\Managers\TimelineManager;
use Project\Managers\WizardManager;
use Project\Managers\ReferencesManager;
use Project\Middleware\WebsiteServices;
use Project\Middleware\DataLoader;
use Zend\Cache\Storage\Adapter\Filesystem;
use Zend\Mail\Transport\Sendmail;

/**
 * Declare your services specifications here
 */

return [
    new Service([
        'id' => 'matcher',
        'class' => Matcher::class
    ]),

    new Service([
        'id' => 'mailer',
        'class' => Sendmail::class
    ]),
    new Service([
        'id' => 'reference.manager',
        'class' => ReferencesManager::class
    ]),
    new Service([
        'id' => 'media.manager',
        'class' => MediaManager::class
    ]),
    new Service([
        'id' => 'post.hydrator',
        'class' => PostHydrator::class
    ]),
    new Service([
        'id' => 'ref.hydrator',
        'class' => ReferencesHydrator::class
    ]),
    new Service([
        'id' => 'media.hydrator',
        'class' => MediaHydrator::class
    ]),
    new Service([
        'id' => 'services.hydrator',
        'class' => ServicesHydrator::class
    ]),
    new Service([
        'id' => 'services.manager',
        'class' => ServicesManager::class
    ]),
    new Service([
        'id' => 'job.manager',
        'class' => JobManager::class
    ]),
    new Service([
        'id' => 'job.hydrator',
        'class' => JobHydrator::class
    ]),
    new Service([
        'id' => 'timeline.manager',
        'class' => TimelineManager::class
    ]),
    new Service([
        'id' => 'timeline.hydrator',
        'class' => TimelineHydrator::class
    ]),
    new Service([
        'id' => 'helper.data-loader',
        'class' => DataLoader::class,
    ]),
    new Service([
        'id' => 'catalogservice.manager',
        'class' => CatalogServiceManager::class
    ]),
    new Service([
        'id' => 'catalogservice.hydrator',
        'class' => CatalogServiceHydrator::class
    ]),
    new Service([
        'id' => 'sidebar.hydrator',
        'class' => SideBarHydrator::class
    ]),
    new Service([
        'id' => 'sidebar.manager',
        'class' => SideBarManager::class,
    ]),
    new Service([
        'id' => 'wizard.manager',
        'class' => WizardManager::class
    ]),
    new Service([
        'id' => 'wizard-entity.hydrator',
        'class' => WizardEntityHydrator::class
    ]),
    new Service([
        'id' => 'wizard-solution.hydrator',
        'class' => WizardSolutionHydrator::class
    ]),
    new Service([
        'id' => 'jobs-offers.hydrator',
        'class' => OffersHydrator::class
    ]),
    new Service([
        'id' => 'cache.manager',
        'class' => CacheManager::class
    ]),
    new Service([
        'id' => 'blog-post.hydrator',
        'class' => BlogPostHydrator::class
    ]),
    new Service([
        'id' => 'blog-post.manager',
        'class' => BlogPostManager::class
    ]),
    new Service([
        'id' => 'blog-comment.manager',
        'class' => BlogCommentManager::class
    ]),
    new Service([
        'id' => 'blog-comment.hydrator',
        'class' => BlogCommentHydrator::class
    ]),
    new Service([
        'id' => 'comment.hydrator',
        'class' => CommentHydrator::class
    ])
];
