<?php

namespace Project\Action;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;

/**
 * Class Home
 *
 * @package Showcase\Action
 */
class Home extends RenderableAction
{
    /**
     * @param ApplicationInterface
     *
     * @return array
     */
    public function run(ApplicationInterface $app)
    {
        // Vars class holds view variables
        //
        // you can return an array of view variables or
        // directly call it

        Vars::set('page.title', 'Accueil');
        Vars::set('page.subtitle', 'OpCoding met son expérience au service de projets <b><i>PHP</i></b> de qualité');

        Vars::set('page.outsourcing.src', 'images/pic01.jpg');
        Vars::set('page.outsourcing.alt', 'Externalisation');

        Vars::set('page.consulting1.src', 'images/pic02.jpg');
        Vars::set('page.consulting1.alt', 'Expertise');

        Vars::set('page.consulting2.src', 'images/pic03.jpg');
        Vars::set('page.consulting2.alt', 'Expertise');

        Vars::set('page.training.src', 'images/pic04.jpg');
        Vars::set('page.training.alt', 'Formation');
    }
}
