<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 09/06/2017
 * Time: 10:34
 */

namespace Project\Action;

use JakubOnderka\PhpParallelLint\Exception;
use ObjectivePHP\Application\Action\HttpAction;
use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Config\CacheMappingParam;
use Project\Managers\CacheManager;
use Zend\Cache\Storage\Adapter\Filesystem;
use Zend\Diactoros\Response\JsonResponse;

class RefreshCache extends HttpAction
{

    /**
     * @Inject(service="cache.manager")
     */
    protected $cacheManager;


    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        $type = $this->getParam('type');
        $this->getCacheManager()->invalidate($type);
        return new JsonResponse("Cache is cleared");
    }



    /**
     * Get Cache
     *
     * @return CacheManager
     */
    public function getCacheManager()
    {
        return $this->cacheManager;
    }
}
