<?php
namespace Project\Entity;

/** * Class AbstractEntity
 * @package Project\Entity
 */
class AbstractEntity implements \ArrayAccess, \JsonSerializable
{
    /**
     * @param mixed $offset
     * @return bool
     */
    public function offsetExists($offset)
    {
        $offset = lcfirst($this->toCamelCase($offset));

        return isset($this->$offset);
    }

    /**
     * @param mixed $offset
     * @return null
     */
    public function offsetGet($offset)
    {
        $getter = 'get' . $this->toCamelCase($offset);

        if (method_exists($this, $getter)) {
            return $this->$getter();
        }

        return null;
    }

    /**
     * @param mixed $offset
     * @param mixed $value
     * @return null
     */
    public function offsetSet($offset, $value)
    {
        $setter = 'set' . $this->toCamelCase($offset);
        $result = null;

        if (method_exists($this, $setter)) {
            $result = $this->$setter($value);
        }

        return $result;
    }

    /**
     * @param mixed $offset
     */
    public function offsetUnset($offset)
    {
        $property = lcfirst($this->toCamelCase($offset));
        unset($this->$property);
    }

    /**
     * @param $offset
     * @return string
     */
    protected function toCamelCase($offset)
    {
        $parts = explode('_', $offset);
        foreach ($parts as &$part) {
            $part = ucfirst($part);
        }

        return implode('', $parts);
    }

    /**
     * @param $property
     * @return string
     */
    protected function toSnakeCase($property)
    {
        $parts = preg_split('/[A-Z]/', $property);
        foreach ($parts as &$part) {
            $part = strtolower($part);
        }

        return implode('_', $parts);
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        $json = array();
        foreach ($this as $key => $value) {
            $json[$key] = $value;
        }
        return $json;
    }
}
