<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 11/07/17
 * Time: 09:29
 */

namespace Project\Hydrators;

use DateTime;
use Project\Entity\BlogComment;

class BlogCommentHydrator
{

    public function hydrate(BlogComment $blogComment, $rawBlogComment)
    {
        $blogComment->setAuthor($rawBlogComment['author_name']);
        $blogComment->setDate((new DateTime($rawBlogComment['date']))->format("d/m/Y H:i"));
        $blogComment->setContent($rawBlogComment['content']['rendered']);

        return $blogComment;
    }
}
