<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 10/07/17
 * Time: 16:18
 */

namespace Project\Hydrators;

use DateTime;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\BlogComment;
use Project\Entity\BlogPost;

class BlogPostHydrator implements InjectionAnnotationProvider
{
    /**
     * @var BlogCommentHydrator
     * @Inject(service="blog-comment.hydrator")
     */
    protected $blogCommentHydrator;

    public function hydrate(BlogPost $blogPost, $rawBlogPost)
    {
        $blogPost->setId($rawBlogPost['id']);
        $blogPost->setTitle(strip_tags($rawBlogPost['title']['rendered']));
        $blogPost->setContent($rawBlogPost['content']['rendered']);
        $blogPost->setDate((new DateTime($rawBlogPost['date']))->format("d/m/Y H:i"));
        $blogPost->setModificationDate((new DateTime($rawBlogPost['modified']))->format("d/m/Y H:i"));
        $commentHydrator = $this->getBlogCommentHydrator();

        foreach ($rawBlogPost['comments'] as $comment) {
            $blogPost->addComment($commentHydrator->hydrate(new BlogComment(), $comment));
        }

        return $blogPost;
    }

    /**
     * @return BlogCommentHydrator
     */
    public function getBlogCommentHydrator(): BlogCommentHydrator
    {
        return $this->blogCommentHydrator;
    }

    /**
     * @param BlogCommentHydrator
     */
    public function setBlogCommentHydrator(BlogCommentHydrator $blogCommentHydrator)
    {
        $this->blogCommentHydrator = $blogCommentHydrator;
    }
}
