<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 15/05/2017
 * Time: 14:44
 */

namespace Project\Hydrators;

use ObjectivePHP\ServicesFactory\Annotation\Inject;

use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Reference;
use Project\Managers\MediaManager;

class ReferencesHydrator implements InjectionAnnotationProvider
{
    /**
     * @var MediaManager
     * @Inject(service="media.manager")
     */
    protected $media;

    public function hydrate(Reference $reference, $rawRef)
    {
        if ($rawRef['featured_media'] != 0) {
            $media = $this->getMedia()->fetchMedia($rawRef['featured_media']);
            if ($media != null) {
                $reference->setImage($media->getUrl());
                if ($media->getAlt() != null) {
                    $reference->setAltImage($media->getAlt());
                } else {
                    $reference->setAltImage("image non trouvée");
                }
            } else {
                $reference->setImage(null);
                $reference->setAltImage("image non trouvée");
            }
        } else {
            $reference->setAltImage("image non trouvée");
        }


        $reference->setId($rawRef['id']);
        $reference->setTitle(strip_tags($rawRef['title']['rendered']));
        $reference->setContent($rawRef['content']['rendered']);


        return $reference;
    }

    /**
     * @return MediaManager
     */
    public function getMedia(): MediaManager
    {
        return $this->media;
    }

    /**
     * @param MediaManager $media
     */
    public function setMedia(MediaManager $media)
    {
        $this->media = $media;
    }
}
