<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 17/05/17
 * Time: 10:31
 */

namespace Project\Hydrators;

use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Service;

class ServicesHydrator implements InjectionAnnotationProvider
{

    public function hydrate(Service $service, $rawServ)
    {

        $service->setId($rawServ['id']);
        $service->setTitle(strip_tags($rawServ['title']['rendered']));
        $service->setContent($rawServ['content']['rendered']);
        $service->setExcerpt($rawServ['excerpt']['rendered']);
        $service->setSlug($rawServ['slug']);
        $service->setQuote($rawServ['acf']['quote']);


        return $service;
    }
}
