<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 30/05/2017
 * Time: 12:26
 */

namespace Project\Hydrators;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Timeline;
use Project\Managers\MediaManager;

class TimelineHydrator implements InjectionAnnotationProvider
{

    /**
     * @var MediaManager
     * @Inject(service="media.manager")
     */
    protected $media;

    public function hydrate(Timeline $timeline, $rawTimeline)
    {
        if ($rawTimeline['featured_media'] != 0) {
            $media = $this->getMedia()->fetchMedia($rawTimeline['featured_media']);
            if ($media != null) {
                $timeline->setImage($media->getUrl());
                if ($media->getAlt() != null) {
                    $timeline->setAltImage($media->getAlt());
                } else {
                    $timeline->setAltImage("image non trouvée");
                }
            } else {
                $timeline->setImage(null);
                $timeline->setAltImage("image non trouvée");
            }
        } else {
            $timeline->setAltImage("image non trouvée");
        }

        $timeline->setTitle(strip_tags($rawTimeline['title']['rendered']));
        $timeline->setContent($rawTimeline['content']['rendered']);
        $timeline->setQuote($rawTimeline['acf']['quote']);

        return $timeline;
    }

    /**
     * @return MediaManager
     */
    public function getMedia(): MediaManager
    {
        return $this->media;
    }

    /**
     * @param MediaManager $media
     */
    public function setMedia(MediaManager $media)
    {
        $this->media = $media;
    }
}
