<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 07/06/2017
 * Time: 10:42
 */

namespace Project\Hydrators;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\WizardSolution;
use Project\Managers\MediaManager;

class WizardSolutionHydrator implements InjectionAnnotationProvider
{

    /**
     * @var MediaManager
     * @Inject(service="media.manager")
     */
    protected $media;

    public function hydrate(WizardSolution $solution, $rawSolution)
    {
        if ($rawSolution['featured_media'] != 0) {
            $media = $this->getMedia()->fetchMedia($rawSolution['featured_media']);
            if ($media != null) {
                $solution->setImage($media->getUrl());
                if ($media->getAlt() != null) {
                    $solution->setAltImage($media->getAlt());
                } else {
                    $solution->setAltImage("image non trouvée");
                }
            } else {
                $solution->setImage(null);
                $solution->setAltImage("image non trouvée");
            }
        } else {
            $solution->setAltImage("image non trouvée");
        }

        $solution->setTitle(strip_tags($rawSolution['title']['rendered']));
        $solution->setParent($rawSolution['acf']['parent']);
        $solution->setLink($rawSolution['acf']['link']);
        $solution->setId($rawSolution['acf']['id']);

        return $solution;
    }

    /**
     * @return MediaManager
     */
    public function getMedia(): MediaManager
    {
        return $this->media;
    }

    /**
     * @param MediaManager $media
     */
    public function setMedia(MediaManager $media)
    {
        $this->media = $media;
    }
}
