<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 06/06/17
 * Time: 09:56
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;

class AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @Inject(param="wp.api.base-url")
     */
    protected $baseApiUrl;

    protected function query($action, $params = [])
    {

        // TODO handle caching
        $url = $this->getBaseApiUrl() . $action;
        if ($params) {
            $flattenedParams = [];
            foreach ($params as $param => $value) {
                $flattenedParams[] = $param . '=' . $value;
            }
            $url .= '?' . implode('&', $flattenedParams);
        }
        return json_decode(file_get_contents($url), true);
    }

    /**
     * @return mixed
     */
    public function getBaseApiUrl()
    {
        return $this->baseApiUrl;
    }

    /**
     * @param mixed $baseApiUrl
     */
    public function setBaseApiUrl($baseApiUrl)
    {
        $this->baseApiUrl = $baseApiUrl;
    }
}
