<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 11/07/17
 * Time: 09:37
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\BlogComment;
use Project\Hydrators\BlogCommentHydrator;

class BlogCommentManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var BlogCommentHydrator
     * @Inject(service="blog-comment.hydrator")
     */
    protected $blogCommentHydrator;

    public function fetchAllBlogComment()
    {
        $blogComments = $this->query('comments');
        $results = [];
        foreach ($blogComments as $comment) {
            array_push($results, $this->getBlogCommentHydrator()->hydrate(new BlogComment(), $comment));
        }

        return $results;
    }


    /**
     * @return BlogCommentHydrator
     */
    public function getBlogCommentHydrator(): BlogCommentHydrator
    {
        return $this->blogCommentHydrator;
    }

    /**
     * @param BlogCommentHydrator $blogCommentHydrator
     */
    public function setBlogCommentHydrator(BlogCommentHydrator $blogCommentHydrator)
    {
        $this->blogCommentHydrator = $blogCommentHydrator;
    }
}
