<?php

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Zend\Cache\Storage\Adapter\Filesystem;

class CacheManager implements InjectionAnnotationProvider
{

    /**
     * @var Filesystem
     * @Inject(service="cache")
     */
    protected $cache;

    /**
     * @Inject(param="opcoding.base-url")
     */
    protected $baseOpcodingUrl;

    /**
     * @Inject(param="cache.mapping")
     */
    protected $mapping;


    public function invalidate($reference)
    {
        $this->getCache()->removeItem($reference);
    }

    public function warmUp($reference)
    {
        // TODO
    }

    protected function getRemotePath($reference)
    {
        // TODO Handle missing references
        return $this->mapping[$reference];
    }

    /**
     * @return mixed
     */
    public function getBaseOpcodingUrl()
    {
        return $this->baseOpcodingUrl;
    }

    /**
     * @param mixed $baseOpcodingUrl
     */
    public function setBaseOpcodingUrl($baseOpcodingUrl)
    {
        $this->baseOpcodingUrl = $baseOpcodingUrl;
    }

    /**
     * @return Filesystem
     */
    public function getCache()
    {
        return $this->cache;
    }

    /**
     * @param mixed $cache
     */
    public function setCache($cache)
    {
        $this->cache = $cache;
    }

    /**
     * @return mixed
     */
    public function getMapping()
    {
        return $this->mapping;
    }

    /**
     * @param mixed $mapping
     */
    public function setMapping($mapping)
    {
        $this->mapping = $mapping;
    }
}
