<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 31/05/17
 * Time: 14:54
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\CatalogService;
use Project\Hydrators\CatalogServiceHydrator;

class CatalogServiceManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var CatalogServiceHydrator
     * @Inject(service="catalogservice.hydrator")
     */
    protected $catServiceHydrator;


    public function fetchAll()
    {
        $posts = $this->query('catalog');
        $results = [];
        foreach ($posts as $post) {
            $element = $this->getCatServiceHydrator()->hydrate(new CatalogService(), $post);
            $serv = strtolower($element['service']);
            if (!isset($results[$serv])) {
                $results[$serv] = [];
            }
            $results[$serv][] = $element;
        }
        return $results;
    }


    /**
     * @return mixed
     */
    public function getCatServiceHydrator()
    {
        return $this->catServiceHydrator;
    }

    /**
     * @param mixed $catServiceHydrator
     */
    public function setCatServiceHydrator($catServiceHydrator)
    {
        $this->catServiceHydrator = $catServiceHydrator;
    }
}
