<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 17/05/17
 * Time: 14:34
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Job;
use Project\Entity\JobOffer;
use Project\Hydrators\JobHydrator;
use Project\Hydrators\OffersHydrator;
use Zend\Cache\Storage\StorageInterface;

class JobManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var JobHydrator
     * @Inject(service="job.hydrator")
     */
    protected $jobHydrator;

    /**
     * @var OffersHydrator
     * @Inject(service="jobs-offers.hydrator")
     */
    protected $offersHydrator;

    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;

    public function fetchJob()
    {
        if (!$results = $this->getCache()->getItem('jobs')) {
            $jobPage = $this->query('jobs');
            $results = $this->getJobHydrator()->hydrate(new Job, $jobPage);
            $this->getCache()->setItem('jobs', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }

    public function fetchOffers()
    {

        if (!$results = $this->getCache()->getItem('jobs_offers')) {
            $offers = $this->query('jobs_offers');
            $results = [];
            foreach ($offers as $offer) {
                array_push($results, $this->getOffersHydrator()->hydrate(new JobOffer(), $offer));
            }
            $this->getCache()->setItem('jobs_offers', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }

    /**
     * @return JobHydrator
     */
    public function getJobHydrator()
    {
        return $this->jobHydrator;
    }

    /**
     * @param JobHydrator $jobHydrator
     */
    public function setJobHydrator($jobHydrator)
    {
        $this->jobHydrator = $jobHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }

    /**
     * @return OffersHydrator
     */
    public function getOffersHydrator(): OffersHydrator
    {
        return $this->offersHydrator;
    }

    /**
     * @param OffersHydrator $offersHydrator
     */
    public function setOffersHydrator(OffersHydrator $offersHydrator)
    {
        $this->offersHydrator = $offersHydrator;
    }
}
