<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 15/05/2017
 * Time: 17:45
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Hydrators\MediaHydrator;
use Project\Entity\Media;

class MediaManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var MediaHydrator
     * @Inject(service="media.hydrator")
     */
    protected $mediaHydrator;


    public function fetchMedia($relatedMedia)
    {
        $media = $this->query('media/' . $relatedMedia);
        return $this->getMediaHydrator()->hydrate(new Media, $media);
    }

    /**
     * @return MediaHydrator
     */
    public function getMediaHydrator(): MediaHydrator
    {
        return $this->mediaHydrator;
    }

    /**
     * @param MediaHydrator $mediaHydrator
     */
    public function setMediaHydrator(MediaHydrator $mediaHydrator)
    {
        $this->mediaHydrator = $mediaHydrator;
    }
}
