<?php
namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Post;
use Project\Entity\Reference;
use Project\Hydrators\PostHydrator;
use Project\Hydrators\ReferencesHydrator;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use Zend\Cache\Storage\StorageInterface;

/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 11/05/2017
 * Time: 16:00
 */
class ReferencesManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var ReferencesHydrator
     * @Inject(service="ref.hydrator")
     */
    protected $referenceHydrator;

    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;


    public function fetchAll($criteria = [])
    {
        if (!$results = $this->getCache()->getItem('references')) {
            $references = $this->query('references');
            $results = [];
            foreach ($references as $reference) {
                array_push($results, $this->getReferenceHydrator()->hydrate(new Reference, $reference));
            }
            $this->getCache()->setItem('references', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }

    /**
     * @return ReferencesHydrator
     */
    public function getReferenceHydrator(): ReferencesHydrator
    {
        return $this->referenceHydrator;
    }

    /**
     * @param ReferencesHydrator $referenceHydrator
     */
    public function setReferenceHydrator(ReferencesHydrator $referenceHydrator)
    {
        $this->referenceHydrator = $referenceHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }
}
