<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 17/05/17
 * Time: 10:26
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Service;
use Project\Hydrators\ServicesHydrator;
use Zend\Cache\Storage\StorageInterface;

class ServicesManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var ServicesHydrator
     * @Inject(service="services.hydrator")
     */
    protected $servicesHydrator;
    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;


    public function fetch($service)
    {
        $posts = $this->query('services', ['slug' => $service]);
        $results = [];
        foreach ($posts as $post) {
            array_push($results, $this->getServicesHydrator()->hydrate(new Service, $post));
        }
        return $results;
    }

    public function fetchAll()
    {
        if (!$results = $this->getCache()->getItem('services')) {
            $posts = $this->query('services');
            $results = [];
            foreach ($posts as $post) {
                array_push($results, $this->getServicesHydrator()->hydrate(new Service, $post));
            }

            $this->getCache()->setItem('services', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }


    /**
     * @return ServicesHydrator
     */
    public function getServicesHydrator()
    {
        return $this->servicesHydrator;
    }

    /**
     * @param ServicesHydrator $servicesHydrator
     */
    public function setServicesHydrator($servicesHydrator)
    {
        $this->servicesHydrator = $servicesHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }
}
