<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 01/06/17
 * Time: 14:34
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\SideBar;
use Project\Hydrators\SideBarHydrator;
use Zend\Cache\Storage\StorageInterface;

class SideBarManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var SideBarHydrator
     * @Inject(service="sidebar.hydrator")
     */
    protected $sideBarHydrator;

    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;


    public function fetchAll()
    {
        if (!$results = $this->getCache()->getItem('sidebar')) {
            $sideBars = $this->query('sidebar');
            $results = [];
            foreach ($sideBars as $sideBar) {
                array_push($results, $this->getSideBarHydrator()->hydrate(new SideBar(), $sideBar));
            }
            $this->getCache()->setItem('sidebar', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }


    /**
     * @return mixed
     */
    public function getSideBarHydrator()
    {
        return $this->sideBarHydrator;
    }

    /**
     * @param mixed $sideBarHydrator
     */
    public function setSideBarHydrator($sideBarHydrator)
    {
        $this->sideBarHydrator = $sideBarHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }
}
