<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 30/05/2017
 * Time: 12:23
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\Timeline;
use Project\Hydrators\TimelineHydrator;
use Zend\Cache\Storage\StorageInterface;

class TimelineManager extends AbstractManager implements InjectionAnnotationProvider
{

    /**
     * @var TimelineHydrator
     * @Inject(service="timeline.hydrator")
     */
    protected $timelineHydrator;

    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;

    public function fetch($criteria = [])
    {
        if (!$results = $this->getCache()->getItem('timeline')) {
            $posts = $this->query('timeline');
            $results = [];
            foreach ($posts as $post) {
                array_push($results, $this->getTimelineHydrator()->hydrate(new Timeline(), $post));
            }
            $this->getCache()->setItem('timeline', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }

    /**
     * @return TimelineHydrator
     */
    public function getTimelineHydrator(): TimelineHydrator
    {
        return $this->timelineHydrator;
    }

    /**
     * @param TimelineHydrator $timelineHydrator
     */
    public function setTimelineHydrator(TimelineHydrator $timelineHydrator)
    {
        $this->timelineHydrator = $timelineHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }
}
