<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 31/05/2017
 * Time: 14:25
 */

namespace Project\Managers;

use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Entity\WizardEntity;
use Project\Entity\WizardSolution;
use Project\Hydrators\WizardEntityHydrator;
use Project\Hydrators\WizardSolutionHydrator;
use Zend\Cache\Storage\StorageInterface;

class WizardManager extends AbstractManager implements InjectionAnnotationProvider
{


    /**
     * @var WizardEntityHydrator
     * @Inject(service="wizard-entity.hydrator")
     */
    protected $wizardEntityHydrator;

    /**
     * @var WizardSolutionHydrator
     * @Inject(service="wizard-solution.hydrator")
     */
    protected $wizSolutionHydrator;

    /**
     * @var StorageInterface
     * @Inject(service="cache")
     */
    protected $cache;


    public function fetchAllEntities()
    {
        if (!$results = $this->getCache()->getItem('wizard_entity')) {
            $posts = $this->query('wizard_entity');
            $results = [];
            foreach ($posts as $post) {
                array_push($results, $this->getWizardEntityHydrator()->hydrate(new WizardEntity(), $post));
            }
            $this->getCache()->setItem('wizard_entity', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }

    public function fetchAllSolutions()
    {
        if (!$results = $this->getCache()->getItem('wizard_solution')) {
            $posts = $this->query('wizard_solution');
            $results = [];
            foreach ($posts as $post) {
                array_push($results, $this->getWizSolutionHydrator()->hydrate(new WizardSolution(), $post));
            }
            $this->getCache()->setItem('wizard_solution', serialize($results));
        } else {
            $results = unserialize($results);
        }
        return $results;
    }


    /**
     * @return WizardEntityHydrator
     */
    public function getWizardEntityHydrator(): WizardEntityHydrator
    {
        return $this->wizardEntityHydrator;
    }

    /**
     * @param WizardEntityHydrator $wizardEntityHydrator
     */
    public function setWizardEntityHydrator(WizardEntityHydrator $wizardEntityHydrator)
    {
        $this->wizardEntityHydrator = $wizardEntityHydrator;
    }

    /**
     * @return WizardSolutionHydrator
     */
    public function getWizSolutionHydrator(): WizardSolutionHydrator
    {
        return $this->wizSolutionHydrator;
    }

    /**
     * @param WizardSolutionHydrator $wizSolutionHydrator
     */
    public function setWizSolutionHydrator(WizardSolutionHydrator $wizSolutionHydrator)
    {
        $this->wizSolutionHydrator = $wizSolutionHydrator;
    }

    /**
     * @return StorageInterface
     */
    public function getCache(): StorageInterface
    {
        return $this->cache;
    }

    /**
     * @param StorageInterface $cache
     */
    public function setCache(StorageInterface $cache)
    {
        $this->cache = $cache;
    }
}
