<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 30/05/17
 * Time: 14:37
 */

namespace Project\Middleware;

use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\Middleware\AbstractMiddleware;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Managers\CatalogServiceManager;
use Project\Managers\JobManager;
use Project\Managers\ServicesManager;
use Project\Managers\SideBarManager;
use Project\Managers\TimelineManager;
use Project\Managers\ReferencesManager;

class DataLoader extends AbstractMiddleware implements InjectionAnnotationProvider
{

    /**
     * @var ServicesManager
     * @Inject(service="services.manager")
     */
    protected $servicesManager;


    /**
     * @var SideBarManager
     * @Inject(service="sidebar.manager")
     */
    protected $sideBarManager;

    /**
     * @var JobManager
     * @Inject(service="job.manager")
     */
    protected $jobManager;

    /**
     * @param ApplicationInterface $app
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {

        Vars::set('data.services', $this->getServicesManager()->fetchAll());
        Vars::set('data.services.current', $this->getServicesManager()
            ->fetch($app->getRequest()->getParameters()->get('slug')));
        Vars::set('data.side-bar', $this->getSideBarManager()->fetchAll());
        Vars::set('jobs-offers', $this->getJobManager()->fetchOffers());
    }

    /**
     * @return JobManager
     */
    public function getJobManager(): JobManager
    {
        return $this->jobManager;
    }


    /**
     * @return ServicesManager
     */
    public function getServicesManager()
    {
        return $this->servicesManager;
    }


    /**
     * @return mixed
     */
    public function getSideBarManager()
    {
        return $this->sideBarManager;
    }
}
