<?php

namespace Project\Middleware;

use GuzzleHttp\Client;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\Middleware\AbstractMiddleware;
use Project\Application;
use Zend\Cache\Storage\Adapter\Filesystem;

/**
 * Class Cache
 *
 * @package Project\Middleware
 */
class WebsiteServices extends AbstractMiddleware
{
    /**
     * @param Application $app
     */
    public function run(ApplicationInterface $app)
    {
        $app->getServicesFactory()->registerService([
            'id' => 'cache',
            'class' => Filesystem::class,
            'setters' => [
                'setOptions' => [['cache_dir' => $app->getParam('cache.dir')]]
            ]
        ], [
            'id' => 'http.client',
            'class' => Client::class,
            'params' => [
                [
                    'base_uri' => $app->getParam('wp.api.base-url')
                ]
            ]
        ]);
    }
}
