<?php

namespace Project\Package\Corporate;

use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\Application\Workflow\Filter\UrlFilter;
use ObjectivePHP\Config\Loader\DirectoryLoader;
use Project\Application;

/**
 * Class ExamplePackage
 *
 * Access /example on your local copy to trigger some content generation from here
 *
 * @package Showcase\Package\Debug
 */
class CorporatePackage
{

    /**
     * @param ApplicationInterface $app
     *
     * @throws \ObjectivePHP\Config\Exception
     */
    public function __invoke(ApplicationInterface $app)
    {

        // setup autoloading for current package
        //
        // note that a relative path is relative to the application root directory!
        $app->getAutoloader()->addPsr4('Project\\Package\\Corporate\\', 'packages/Corporate/src');


        // init package here
        $configLoader = new DirectoryLoader();
        $configLoader->loadInto($app->getConfig(), __DIR__ . '/config');


        $app->getStep('route')->plug(function () {
            Vars::set('sub-links', ['/corporate/timeline' => 'Historique', '/corporate/references' => 'Références']);
        }, function ($app) {
            $filters = [];
            array_push($filters, new UrlFilter('/corporate/timeline'));
            array_push($filters, new UrlFilter('/corporate/references'));
            foreach ($filters as $filter) {
                $filter->setApplication($app);
                if ($filter($app)) {
                    return true;
                }
            }
            return false;
        });
    }
}
