<?php
/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 10/07/17
 * Time: 16:12
 */

namespace Project\Package\Corporate\Action;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use Project\Managers\BlogCommentManager;
use Project\Managers\BlogPostManager;

class Blog extends RenderableAction
{

    /**
     * @var BlogPostManager
     * @Inject(service="blog-post.manager")
     */
    protected $blogPostManager;

    /**
     * @var BlogCommentManager
     * @Inject(service="blog-comment.manager")
     */
    protected $blogCommentManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        Vars::set('page.title', 'Blog');
        Vars::set('page.subtitle', 'Blog');

        $currentPage = $this->getParam('page');
        $blogPosts = $this->getBlogPostManager()->getOnePost($currentPage);
        $nbPages = $this->getBlogPostManager()->countPages();

        if (null === $currentPage || !is_numeric($currentPage) || $currentPage > $nbPages) {
            $currentPage = 1;
        }

        $currentPage = (int)$currentPage;
        $return = compact('blogPosts', 'nbPages', 'currentPage');

        return $return;
    }

    /**
     * @return BlogPostManager
     */
    public function getBlogPostManager(): BlogPostManager
    {
        return $this->blogPostManager;
    }

    /**
     * @param BlogPostManager $blogPostManager
     */
    public function setBlogPostManager(BlogPostManager $blogPostManager)
    {
        $this->blogPostManager = $blogPostManager;
    }

    /**
     * @return mixed
     */
    public function getBlogCommentManager()
    {
        return $this->blogCommentManager;
    }

    /**
     * @param mixed $blogCommentManager
     */
    public function setBlogCommentManager($blogCommentManager)
    {
        $this->blogCommentManager = $blogCommentManager;
    }
}
