<?php
namespace Project\Package\Corporate\Action\Blog;

use ObjectivePHP\Application\Action\HttpAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use Project\Entity\Comment as CommentEntity;
use Project\Hydrators\CommentHydrator;
use Project\Managers\BlogPostManager;
use Zend\Diactoros\Response\RedirectResponse;

/**
 * Created by PhpStorm.
 * User: workclem
 * Date: 11/07/17
 * Time: 15:07
 */
class Comment extends HttpAction
{

    /**
     * @var CommentHydrator
     * @Inject(service="comment.hydrator")
     */
    protected $commentHydrator;

    /**
     * @var BlogPostManager
     * @Inject(service="blog-post.manager")
     */
    protected $blogPostManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return RedirectResponse
     */
    public function run(ApplicationInterface $app)
    {
        $comment = $this->getCommentHydrator()->hydrate(new CommentEntity(), $this->getParams()->fromPost()->toArray());
        $this->getBlogPostManager()->addComment($comment);

        return new RedirectResponse("/blog");
    }

    /**
     * @return CommentHydrator
     */
    public function getCommentHydrator()
    {
        return $this->commentHydrator;
    }

    /**
     * @return BlogPostManager
     */
    public function getBlogPostManager()
    {
        return $this->blogPostManager;
    }
}
