<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 18/04/2017
 * Time: 13:57
 */

namespace Project\Package\Corporate\Action\Corporate;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use Project\Managers\JobManager;

class Jobs extends RenderableAction
{

    /**
     * @var JobManager
     * @Inject(service="job.manager")
     */
    protected $jobManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        $job = $this->getJobManager()->fetchJob();
        $job = compact('job');

        Vars::set('page.title', 'Emploi');
        Vars::set('page.subtitle', $job['job']['quote']);

        $jobsOffers = $this->getJobManager()->fetchOffers();

        if ($this->getParam('offer') != '') {
            foreach ($jobsOffers as $offer) {
                if ($this->getParam('offer') == $offer['slug']) {
                    Vars::set('offer.content', $offer);
                }
            }
        }
        return $job;
    }

    /**
     * @return JobManager
     */
    public function getJobManager()
    {
        return $this->jobManager;
    }

    /**
     * @param JobManager $jobManager
     */
    public function setJobManager($jobManager)
    {
        $this->jobManager = $jobManager;
    }
}
