<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 20/04/2017
 * Time: 16:19
 */

namespace Project\Package\Corporate\Action\Corporate;

use ObjectivePHP\Application\Action\HttpAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\Config\Param;
use ObjectivePHP\Application\Session\Session;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Zend\Diactoros\Response\RedirectResponse;
use Zend\Mail\Message;
use Zend\Mail\Transport\Smtp;
use ObjectivePHP\ServicesFactory\Annotation\Inject;

/**
 * Class Home
 *
 * @package Showcase\Action
 */
class Mail extends HttpAction implements InjectionAnnotationProvider
{
    /**
     * @Inject(service="mailer")
     *
     * @var Smtp
     */
    protected $mailer;

    /**
     * @param ApplicationInterface $app
     *
     * @return RedirectResponse
     */
    public function run(ApplicationInterface $app)
    {

        date_default_timezone_set('Europe/Paris');
        $post = $this->getApplication()->getRequest()->getParameters()->fromPost();
        if ($post->get('github-link') != "") {
            $github = $post->get('github-link');
            $github = 'Github    : ' . $github;
        }
        if ($post->get('linkedin') != "") {
            $linkedIn = $post->get('linkedin');
            $linkedIn = 'LinkedIn  : ' . $linkedIn;
        }
        $from = $post->get('email');
        $name = $post->get('name');
        $firstname = $post->get('firstname');
        $phone = $post->get('phone');
        $company = $post->get('company');
        $content = $post->get('message');
        $object = $post->get('object');
        $date = date('d/m/Y à H:i');
        $body = <<<BODY

Le $date, un message a été envoyé depuis opcoding.eu :

Nom       : $name
Prénom    : $firstname
Société   : $company
Email     : $from
Téléphone : $phone
$github
$linkedIn

Message :

$content


BODY;
        $message = new Message();
        $message->setEncoding('UTF-8');
        $message->getHeaders()->addHeaderLine('Content-Type', 'text/plain; charset=UTF-8');
        $message->setSubject($object);
        $message->setBody($body);
        $message->setFrom($from);
        $message->setSender($from);
        $message->addTo($app->getConfig()->subset(Param::class)->get('contact-form-recipient'));

        $this->getMailer()->send($message);

        return new RedirectResponse("/");
    }

    /**
     * @return Smtp
     */
    public function getMailer()
    {
        return $this->mailer;
    }

    /**
     * @param mixed $mailer
     */
    public function setMailer($mailer)
    {
        $this->mailer = $mailer;
    }
}
