<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 18/04/2017
 * Time: 13:57
 */

namespace Project\Package\Corporate\Action\Corporate;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Managers\ReferencesManager;
use ObjectivePHP\ServicesFactory\Annotation\Inject;

class References extends RenderableAction implements InjectionAnnotationProvider
{

    /**
     * @var ReferencesManager
     * @Inject(service="reference.manager")
     */
    protected $referenceManager;


    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        Vars::set('page.title', 'Références');
        Vars::set('page.subtitle', 'Ils nous ont fait confiance');
        Vars::set('data.refs', $this->getReferenceManager()->fetchAll());
    }

    /**
     * @return mixed
     */
    public function getReferenceManager()
    {
        return $this->referenceManager;
    }

    /**
     * @param mixed $referenceManager
     */
    public function setReferenceManager($referenceManager)
    {
        $this->referenceManager = $referenceManager;
    }
}
