<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 18/04/2017
 * Time: 13:57
 */

namespace Project\Package\Corporate\Action\Corporate;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Managers\TimelineManager;

class Timeline extends RenderableAction implements InjectionAnnotationProvider
{
    /**
     * @var TimelineManager
     * @Inject(service="timeline.manager")
     */
    protected $timelineManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        Vars::set('data.timeline', $this->getTimelineManager()->fetch());

        Vars::set('page.title', 'Historique');
        Vars::set('page.subtitle', Vars::get('data.timeline')['0']['quote']);
    }

    /**
     * @return mixed
     */
    public function getTimelineManager()
    {
        return $this->timelineManager;
    }

    /**
     * @param mixed $timelineManager
     */
    public function setTimelineManager($timelineManager)
    {
        $this->timelineManager = $timelineManager;
    }
}
