<?php

namespace Project\Package\Services;

use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\Application\Workflow\Filter\UrlFilter;
use ObjectivePHP\Config\Loader\DirectoryLoader;
use Project\Application;

/**
 * Class ExamplePackage
 *
 * Access /example on your local copy to trigger some content generation from here
 *
 * @package Showcase\Package\Debug
 */
class ServicesPackage
{

    /**
     * @param ApplicationInterface $app
     *
     * @throws \ObjectivePHP\Config\Exception
     */
    public function __invoke(ApplicationInterface $app)
    {

        // setup autoloading for current package
        // note that a relative path is relative to the application root directory!
        $app->getAutoloader()->addPsr4('Project\\Package\\Services\\', 'packages/Services/src');

        // init package here
        $configLoader = new DirectoryLoader();
        $configLoader->loadInto($app->getConfig(), __DIR__ . '/config');


        $app->getStep('route')->plug(function () {
            $services = Vars::get('data.services');
            foreach ($services as $serv) {
                $subLinks['/services?slug=' . $serv['slug']] = $serv['title'];
            }
            Vars::set('sub-links', $subLinks);
        }, function (ApplicationInterface $app) {
            $queryStrings = explode('=', $app->getRequest()->getUri()->getQuery());
            return in_array('slug', $queryStrings);
        });
    }
}
