<?php
/**
 * Created by PhpStorm.
 * User: Quentin
 * Date: 18/04/2017
 * Time: 13:57
 */

namespace Project\Package\Services\Action\Services;

use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\Application\View\Helper\Vars;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use Project\Managers\CatalogServiceManager;

class Catalog extends RenderableAction
{

    /**
     * @var CatalogServiceManager
     * @Inject(service="catalogservice.manager")
     */
    protected $catServiceManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {
        $catalog = $this->getCatServiceManager()->fetchAll();
        Vars::set('page.title', 'Catalogue');
        Vars::set('page.subtitle', 'Retrouvez ci-dessous l\'ensemble de nos prestations.');
        return compact('catalog');
    }

    /**
     * @return CatalogServiceManager
     */
    public function getCatServiceManager()
    {
        return $this->catServiceManager;
    }
}
