<?php

namespace Project\Package\Services\Action\Wizard;

use ObjectivePHP\Application\Action\AjaxAction;
use ObjectivePHP\Application\Action\RenderableAction;
use ObjectivePHP\Application\ApplicationInterface;
use ObjectivePHP\ServicesFactory\Annotation\Inject;
use ObjectivePHP\ServicesFactory\Specs\InjectionAnnotationProvider;
use Project\Managers\WizardManager;
use Zend\Diactoros\Response\JsonResponse;

class WizardData extends AjaxAction implements InjectionAnnotationProvider
{

    /**
     * @var WizardManager
     * @Inject(service="wizard.manager")
     */
    protected $wizardManager;

    /**
     * @param ApplicationInterface $app
     *
     * @return mixed
     */
    public function run(ApplicationInterface $app)
    {

        $wizard = $this->getWizardManager()->fetchAllEntities();
        $solutions = $this->getWizardManager()->fetchAllSolutions();
        $tree = [
            'name' => 'tree',
            'selected' => true,
            'solutions' => null,
            'children' => null,
            'parent' => '-2',
            'id' => '-1',
        ];


        $tab = $this->createNodes($wizard);
        $tree['children'] = $this->constructTree($tree['id'], $tab, $solutions);


        return new JsonResponse($tree);
    }

    /**
     * @return WizardManager
     */
    public function getWizardManager(): WizardManager
    {
        return $this->wizardManager;
    }

    /**
     * @param WizardManager $wizardManager
     */
    public function setWizardManager(WizardManager $wizardManager)
    {
        $this->wizardManager = $wizardManager;
    }


    public function createNodes($array)
    {
        $tab = [];
        foreach ($array as $entity) {
            array_push($tab, $entity->jsonSerialize());
        }
        return $tab;
    }

    public function constructTree($parent, $tab, $solutions)
    {
        $result = [];
        foreach ($tab as $node) {
            if ($node['parent'] == $parent) {
                $result[$node['id']] = [
                    'name' => $node['name'],
                    'selected' => $node['selected'],
                    'solutions' => $this->constructSolutions($node['id'], $solutions),
                    'children' => $this->constructTree($node['id'], $tab, $solutions),
                    'parent' => $node['parent'],
                    'id' => $node['id']
                ];
            }
        }
        if (!empty($result)) {
            $object = (object)$result;
        } else {
            $object = null;
        }

        return $object;
    }

    public function constructSolutions($parent, $tab)
    {
        $result = [];
        foreach ($tab as $solution) {
            if ($parent == $solution['parent']) {
                $result[$solution['id']] = [
                    'label' => $solution['title'],
                    'icon' => $solution['image'],
                    'link' => $solution['link']
                ];
            }
        }
        if (empty($result)) {
            $object = null;
        } else {
            $object = (object)$result;
        }

        return $object;
    }
}
