var div = document.getElementById('wiz');


function loadTree() {
    $.ajax('/wizard/wizard-data', {
        type: "GET",
        context: this,
        xhrFields: {
            withCredentials: true
        },

        success: function (data) {
            tree = data;
            init(tree);
        },

        error: function (jqXHR, textStatus, errorThrown) {
            console.log(jqXHR.status);
        }
    });
}

function createSolution(solution) {
    var sol = document.createElement('div');
    sol.className = 'solution';

    var para = document.createElement('p');
    para.className = 'solution-para';

    var label = document.createElement('h3');
    label.innerText = solution.label;
    label.className = 'solution-label';

    var link = document.createElement('a');
    link.href = solution.link;
    link.innerText = 'En savoir plus...';
    link.className = 'solution-link';

    var icon = document.createElement('img');
    icon.src = solution.icon;
    icon.className = 'solution-icon';

    para.appendChild(label);
    para.appendChild(link);
    sol.appendChild(icon);
    sol.appendChild(para);


    div.appendChild(sol);

}


function showSolutions(node) {
    var solutions = node['solutions'];

    var title = document.createElement('h3');
    title.className = 'solution-title';
    if (solutions != null) {
        title.innerText = 'Voici nos solutions pouvant convenir à votre demande : ';
        div.appendChild(title);
        for (var solution in solutions) {
            createSolution(solutions[solution]);
        }
    }
    else if (node['children'] == null) {
        title.innerText = 'Pas de solutions';
        div.appendChild(title);
    }
}


function changeSelectedButton(button) {
    button.style.backgroundColor = '#002A47';
    button.style.color = 'white';
    button.style.border = '2px solid #002A47';
}

function initButton(object) {
    var button = document.createElement('button');
    button.value = '' + object['name'];
    button.className = 'wiz-button';
    button.innerText = '' + object['name'];
    return button;
}

function createButton(object) {
    var button = initButton(object);
    var selected = object['selected'];
    if (selected) {
        changeSelectedButton(button);
    }else{
        button.addEventListener('click', function () {
            object['selected'] = true;
            deleteButtons();
            init(tree);
            showSolutions(object);

        });
    }

    return button
}


function deleteButtons() {
    div.innerHTML = '';
}


function createDiv() {
    var wizContent = document.createElement('div');
    wizContent.className = 'wiz-content';
    return wizContent;
}

function createSeparation() {
    var div = document.createElement('div');
    div.className = 'separator';
    var par = document.createElement('p');
    par.className = 'separator-head';
    par.innerHTML = '&#8595;';
    div.appendChild(par);
    return div;
}

function desinit(node) {
    var tmp = true;
    var children = node['children'];
    var selected = node['selected'];
    while (tmp) {
        if (selected && children != null) {
            for (var child in node['children']) {
                tmp = desinit(children[child]);
                children[child].selected = false;
            }
        }
        else {
            return false;
        }
    }
}

function desinitBrothers(parent, node) {
    var tmp = true;
    var children = parent['children'];
    while (tmp) {
        if (children != null) {
            for (var child in children) {
                if (children[child] == node) {
                    desinit(parent);
                    return false;
                }
                else {
                    tmp = desinitBrothers(children[child], node);
                }
            }
        }
        else {
            return false;
        }
    }
}


function createCancelButton(selectedNode) {
    var cancelButton = document.createElement('button');
    cancelButton.className = 'solution-cancel-button';
    cancelButton.innerHTML = '&#8635;';
    cancelButton.value = selectedNode.value;
    cancelButton.addEventListener('click', function () {
        desinitBrothers(tree, selectedNode);
        deleteButtons();
        init(tree);
    });
    return cancelButton;
}


function init(node) {
    var tmp = true;
    var selectedNode;
    var children = node['children'];
    var selected = node['selected'];

    while (tmp) {
        if (selected && children != null) {
            var wizContent = createDiv();
            for (var child in children) {
                if (children[child].selected) {
                    selectedNode = children[child];
                }
            }
            if (selectedNode == null) {
                for (var child in children) {
                    var button = createButton(children[child]);
                    wizContent.appendChild(button);
                    tmp = init(children[child]);
                }
            } else {
                var cancelButton = createCancelButton(selectedNode);
                var button = createButton(selectedNode);
                wizContent.appendChild(cancelButton);
                wizContent.appendChild(button);
                var separation = createSeparation();
                wizContent.appendChild(separation);
                tmp = init(selectedNode);
            }
            div.insertBefore(wizContent, div.firstChild)
        } else {
            return false;
        }
    }


}
document.addEventListener("DOMContentLoaded", function(){
    loadTree();
});


